/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.util;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.PrimitiveCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.lang.runtime.SwitchBootstraps;
import java.util.Optional;
import java.util.OptionalInt;
import net.minecraft.locale.Language;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import org.jetbrains.annotations.NotNull;
import snownee.jade.api.config.IgnoreList;

public class JadeCodecs {
    public static final Codec<OptionalInt> OPTIONAL_INT = new Codec<OptionalInt>(){

        public <T> DataResult<Pair<OptionalInt, T>> decode(DynamicOps<T> ops, T input) {
            return DataResult.success((Object)((Pair)ops.getNumberValue(input).mapOrElse(number -> Pair.of((Object)OptionalInt.of(number.intValue()), (Object)ops.empty()), ignored -> Pair.of((Object)OptionalInt.empty(), (Object)ops.empty()))));
        }

        public <T> DataResult<T> encode(OptionalInt input, DynamicOps<T> ops, T prefix) {
            if (input.isPresent()) {
                return DataResult.success((Object)ops.createInt(input.getAsInt()));
            }
            return DataResult.success((Object)ops.empty());
        }
    };
    public static final PrimitiveCodec<Object> PRIMITIVE = new PrimitiveCodec<Object>(){

        public <T> DataResult<Object> read(DynamicOps<T> ops, T input) {
            DataResult result = ops.getBooleanValue(input);
            if (result.isSuccess()) {
                return result.map($ -> $);
            }
            result = ops.getNumberValue(input);
            if (result.isSuccess()) {
                return result.map($ -> $);
            }
            result = ops.getStringValue(input);
            if (result.isSuccess()) {
                return result.map($ -> $);
            }
            return DataResult.error(() -> "Not a primitive value: " + String.valueOf(input));
        }

        public <T> T write(DynamicOps<T> ops, Object value) {
            if (value instanceof Boolean) {
                return (T)ops.createBoolean(((Boolean)value).booleanValue());
            }
            if (value instanceof Number) {
                return (T)ops.createNumeric((Number)value);
            }
            if (value instanceof String) {
                return (T)ops.createString((String)value);
            }
            throw new IllegalArgumentException("Not a primitive value: " + String.valueOf(value));
        }
    };
    public static final StreamCodec<ByteBuf, Object> PRIMITIVE_STREAM_CODEC = new StreamCodec<ByteBuf, Object>(){

        @NotNull
        public Object decode(ByteBuf buf) {
            byte b = buf.readByte();
            if (b == 0) {
                return false;
            }
            if (b == 1) {
                return true;
            }
            if (b == 2) {
                return ByteBufCodecs.VAR_INT.decode((Object)buf);
            }
            if (b == 3) {
                return ByteBufCodecs.FLOAT.decode((Object)buf);
            }
            if (b == 4) {
                return ByteBufCodecs.STRING_UTF8.decode((Object)buf);
            }
            if (b > 20) {
                return b - 20;
            }
            throw new IllegalArgumentException("Unknown primitive type: " + b);
        }

        public void encode(ByteBuf buf, Object o) {
            Object object = o;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Boolean.class, Number.class, String.class, Enum.class}, (Object)object, n)) {
                case 0: {
                    Boolean b = (Boolean)object;
                    buf.writeByte(b != false ? 1 : 0);
                    break;
                }
                case 1: {
                    int i;
                    Number n2 = (Number)object;
                    float f = n2.floatValue();
                    if (f != (float)((int)f)) {
                        buf.writeByte(3);
                        ByteBufCodecs.FLOAT.encode((Object)buf, (Object)Float.valueOf(f));
                    }
                    if ((i = n2.intValue()) <= 107 && i >= 0) {
                        buf.writeByte(i + 20);
                        break;
                    }
                    ByteBufCodecs.VAR_INT.encode((Object)buf, (Object)i);
                    break;
                }
                case 2: {
                    String s = (String)object;
                    buf.writeByte(4);
                    ByteBufCodecs.STRING_UTF8.encode((Object)buf, (Object)s);
                    break;
                }
                case 3: {
                    Enum anEnum = (Enum)object;
                    buf.writeByte(4);
                    ByteBufCodecs.STRING_UTF8.encode((Object)buf, (Object)anEnum.name());
                    break;
                }
                case -1: {
                    throw new NullPointerException();
                }
                default: {
                    throw new IllegalArgumentException("Unknown primitive type: %s (%s)".formatted(o, o.getClass()));
                }
            }
        }
    };

    public static Codec<IgnoreList> ignoreList() {
        return RecordCodecBuilder.create(i -> i.group((App)Codec.STRING.optionalFieldOf("__comment", (Object)"").forGetter($ -> Language.getInstance().getOrDefault("jade.ignore_list.comment", "This is an ignore list for the target of Jade. You can add registry ids to the \"values\" list.")), (App)Codec.STRING.listOf().fieldOf("values").forGetter($ -> $.values), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("version", (Object)1).forGetter($ -> $.version)).apply((Applicative)i, (comment, values, version) -> {
            IgnoreList ignoreList = new IgnoreList();
            ignoreList.values = values;
            ignoreList.version = version;
            return ignoreList;
        }));
    }

    public static Codec<int[]> intArrayCodec(int size, Codec<Integer> codec) {
        return Codec.list(codec).flatXmap($ -> {
            if (size != 0 && size != $.size()) {
                return DataResult.error(() -> "Expected array of length " + size + ", got " + $.size());
            }
            int[] array = new int[size == 0 ? $.size() : size];
            for (int i = 0; i < array.length; ++i) {
                array[i] = (Integer)$.get(i);
            }
            return DataResult.success((Object)array);
        }, $ -> {
            if (size != 0 && size != ((int[])$).length) {
                return DataResult.error(() -> "Expected array of length " + size + ", got " + ((int[])$).length);
            }
            IntArrayList list = new IntArrayList(((int[])$).length);
            for (int i : $) {
                list.add(i);
            }
            return DataResult.success((Object)list);
        });
    }

    public static Codec<float[]> floatArrayCodec(int size, Codec<Float> codec) {
        return Codec.list(codec).flatXmap($ -> {
            if (size != 0 && size != $.size()) {
                return DataResult.error(() -> "Expected array of length " + size + ", got " + $.size());
            }
            float[] array = new float[size == 0 ? $.size() : size];
            for (int i = 0; i < array.length; ++i) {
                array[i] = ((Float)$.get(i)).floatValue();
            }
            return DataResult.success((Object)array);
        }, $ -> {
            if (size != 0 && size != ((float[])$).length) {
                return DataResult.error(() -> "Expected array of length " + size + ", got " + ((float[])$).length);
            }
            FloatArrayList list = new FloatArrayList(((float[])$).length);
            for (float f : $) {
                list.add(f);
            }
            return DataResult.success((Object)list);
        });
    }

    public static Optional<int[]> nullableClone(int[] array) {
        if (array == null) {
            return Optional.empty();
        }
        return Optional.of((int[])array.clone());
    }

    public static Optional<float[]> nullableClone(float[] array) {
        if (array == null) {
            return Optional.empty();
        }
        return Optional.of((float[])array.clone());
    }

    public static <T> T createFromEmptyMap(Codec<T> codec) {
        return (T)codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)JsonOps.INSTANCE.emptyMap())).getOrThrow();
    }
}

